uniform float u_interPoint;
uniform float u_lowerOffset;
//visible area
uniform vec4 u_lowerColor;
uniform vec4 u_upperColor;
uniform float u_starIntensity;
uniform vec2 u_starsTileAmount;
uniform float u_time;
uniform float u_tiltSpeed;
#define PI2 6.28318530717959
#define PI 3.141592653589793

varying vec2 v_texCoord;

void main()
{
  
    //t:0->1
    float t =  v_texCoord.y;
    //Offset for color inteporlation
    float t_inter = (t-u_lowerOffset) / (1.0-u_lowerOffset) / u_interPoint;
    vec4 color = mix(u_lowerColor , u_upperColor , t_inter);
    
    //s:0->1
    float s =  v_texCoord.x;
    
    vec2 samplePoint = vec2(s,t)* u_starsTileAmount;
    samplePoint = mod(samplePoint, 1.0);
    
    vec4 stars = vec4(0.0);
    //vec4 starColor = texture2D(CC_Texture2,vec2(s,t) * u_starsTileAmount);
    vec4 starColor = texture2D(CC_Texture1,samplePoint);
    vec4 starProps = texture2D(CC_Texture2,samplePoint);

    if( u_starIntensity > 0.0 )
    {
        stars = starColor * starProps.r * (sin( (u_tiltSpeed * u_time * starProps.b + starProps.g) * PI2)+1.0)  * u_starIntensity;
    }
    
     //gl_FragColor = mix(color , stars * u_starIntensity , stars.a);
    gl_FragColor = (1.0 - stars.a) * color +  stars;
    
}
